
#ifndef _1_CRYS_ATP_TST_RC4_Acceptance_h_H
#define _1_CRYS_ATP_TST_RC4_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_RC4_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 07 16:53:29 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SYS_TS_RC4_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/
typedef struct TST_RC4_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t 					TST_Key[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_KeySize;
	DxUint8_t 					TST_input_data[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_output_data[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_Expected_output_data[TST_RC4_DATA_VEC_SIZE_IN_BYTS];
	DxUint16_t					TST_dataSize;	
} TST_RC4_TestDataStruct;
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RC4_Acceptance_NON_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RC4 non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using RC4 
 *  Vector sizes used (in bytes) - 16/32/45/512/1536
 *  Key Size used (in bytes)    - 16/32/45/256
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_RC4_Init function to start the encryption/decryption process
 * 2. Call the CRYS_RC4_Stream - This function is called N times
 *                              (N = number of blocks in data each block is 1byte)
 * 3. Call the CRYS_RC4_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one													
 *
 **************************/								
CRYSError_t CRYS_ATP_TST_RC4_Acceptance_NON_integrated ( void );                             
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RC4_Acceptance_integrated 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for RC4 non integrated API's							
 * 	This function Encrypts and Decrypts known vectors using RC4 
 *  Vector sizes used (in bytes) - 16/32/45/512/1536
 *  Key Size used (in bytes)    - 16/32/45/256						
 * 	This also outputs the results to an output buffer or the same input buffer
 * Algorithm:		
 * 1. Call the CRYS_RC4_to Preform the encryption/decryption process
 * 2. Compare the outputted result to the expected one													
 *
 **************************/	
CRYSError_t CRYS_ATP_TST_RC4_Acceptance_Integrated ( void );

#ifdef __cplusplus
}
#endif

#endif

#endif

